
//
// To jest przykadowy kod z podrozdziau 18.6.2 Wykorzystanie tablic ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

bool is_palindrome(const char s[], int n)
// s wskazuje pierwszy znak tablicy n znakw.
{
    int first = 0;         // Indeks pierwszej litery.
    int last = n-1;        // Indeks ostatniej litery.
    while (first < last) { // Nie doszlimy jeszcze do rodka.
        if (s[first]!=s[last]) return false;
        ++first;           // Przesuwa w przd.
        --last;            // Przesuwa wstecz.
    }
    return true;
}

//------------------------------------------------------------------------------

istream& read_word(istream& is, char* buffer, int max)
// Wczytuje najwyej max1 znakw z is do bufora.
{
    is.width(max);         // Wczytuje najwyej max1 znakw w znajdujcym si dalej >>.
    is >> buffer;          // Wczytuje zakoczone spacj sowo,
                           // i dodaje zero za ostatnim znakiem wczytanym do p.
    return is;
}

//------------------------------------------------------------------------------

int main()
{
    const int max = 128;
    char s[max];
    while (read_word(cin,s,max)) { 
        cout << s;
        if (!is_palindrome(s,strlen(s))) cout << " nie";
        cout << " jest palindromem.\n";
    }
}

//------------------------------------------------------------------------------
